unit FormOsoby;

interface

uses
  Windows, Messages, Classes, SysUtils, Graphics, Controls, StdCtrls, Forms,
  Dialogs, DBCtrls, DB, DBGrids, Grids, ExtCtrls, ActnList, Buttons;

type
  TFOsoby = class(TForm)
    DBGrid1: TDBGrid;
    Panel1: TPanel;
    Panel2: TPanel;
    SpeedButton1: TSpeedButton;
    SpeedButton3: TSpeedButton;
    SpeedButton4: TSpeedButton;
    SpeedButton5: TSpeedButton;
    ActionList1: TActionList;
    ActionClose: TAction;
    ActionInsert: TAction;
    ActionEdit: TAction;
    ActionDelete: TAction;
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormDestroy(Sender: TObject);
    procedure ActionCloseExecute(Sender: TObject);
    procedure ActionEditExecute(Sender: TObject);
    procedure DBGrid1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure DBGrid1DblClick(Sender: TObject);
    procedure ActionInsertExecute(Sender: TObject);
    procedure ActionDeleteExecute(Sender: TObject);
  private
    { private declarations }
  public
    { public declarations }
    procedure  my_edit();
    procedure  my_insert();
    procedure  my_delete();
    
    procedure  ustaw_sie_na_nowym_rek(idosoby: Integer);
  end;

var
  FOsoby: TFOsoby;

implementation
{$R *.DFM}

uses
   DataModule, DialogOsoba;

procedure TFOsoby.FormCreate(Sender: TObject);
begin
   Position := poDefault;
   Top      := 60;
   Left     := 0;
   Width    := Screen.Width;
   Height   := Screen.Height - 100;

   DM.QueryOsoby.Open();
end;

procedure TFOsoby.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   Action := caFree;
end;

procedure TFOsoby.FormDestroy(Sender: TObject);
begin
   DM.QueryOsoby.Close();
   FOsoby := NIL;   

end;

procedure TFOsoby.ActionCloseExecute(Sender: TObject);
begin
   Close();
end;

procedure TFOsoby.ActionEditExecute(Sender: TObject);
begin
   my_edit();
end;

procedure TFOsoby.DBGrid1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
   if key = VK_RETURN then begin
      my_edit();
   end;

   if key = VK_INSERT then begin
      my_insert();
   end;

   if key = VK_DELETE then begin
      my_delete();
   end;      

end;

procedure TFOsoby.DBGrid1DblClick(Sender: TObject);
begin
   my_edit();
end;

procedure TFOsoby.ActionInsertExecute(Sender: TObject);
begin
   my_insert();
end;

procedure TFOsoby.ActionDeleteExecute(Sender: TObject);
begin
   my_delete();
end;

procedure TFOsoby.ustaw_sie_na_nowym_rek(idosoby: Integer);
var
   wykonuj : Boolean;
   id      : Integer;
begin
   DM.QueryOsoby.First();

   wykonuj := True;

   DM.QueryOsoby.DisableControls();

   while Wykonuj do begin
      if DM.QueryOsoby.EOF then begin
         Wykonuj := False;
         Continue;
      end;

      id := DM.QueryOsoby.FieldByName('IDOSOBY').AsInteger;

      if id = idosoby then begin
         Wykonuj := False;
         Continue;
      end;

      DM.QueryOsoby.Next();
   end;

   DM.QueryOsoby.EnableControls();
end;

procedure TFOsoby.my_delete();
var
   id : Integer;

begin
   if DM.QueryOsoby.RecordCount = 0 then begin
      EXIT;
   end;
   
   if MessageBox(0, PChar('Usun rekord ?'), 'Ostrzeenie', MB_YESNO ) = IDYES then begin
      id := DM.QueryOsoby.FieldByName('IDOSOBY').AsInteger;

      with DM.QueryOsoby do begin
         Close();

         SQL.Clear();
         SQL.Add('delete from OSOBY ');
         SQL.Add('where IDOSOBY = :IDOSOBY');
         ParamByName('IDOSOBY').AsInteger := Id;

         try
            ExecSQL();
         finally
            Close();
         end;
      end;

      // odwieam ekran i przywracam poprzedni zawarto
      // polecenia SQL
      with DM.QueryOsoby do begin
         Close();

         SQL.Clear();
         SQL.Add('select * from OSOBY');
         SQL.Add('order by NAZWISKO, IMIE');

         Open();
      end;
   end;
end;

procedure TFOsoby.my_insert();
var
   recs : Integer;
   Res  : TModalResult;

begin
   if DM.QueryOsoby.RecordCount = 0 then begin
      EXIT;
   end
   else begin
      recs := DM.QueryOsoby.RecordCount;
      // jeeli numeracja IDOSOBY zaczyna sie od jeden wwczas Inc(recs);
      // jeeli tak jak u mnie zaczyna si od zera to recs pozotsje bez zmian
   end;

   try
      DlgOsoba := TDlgOsoba.Create(Self);
      DM.QueryOsoby.Append();
      DM.QueryOsobyIDOSOBY.Value := recs;

      res := DlgOsoba.ShowModal();

      if res = mrOK then begin
         DM.QueryOsoby.Close();
         DM.QueryOsoby.Open();

         ustaw_sie_na_nowym_rek(recs);
      end;
   finally
      FreeAndNil(DlgOsoba);
   end;
end;

procedure TFOsoby.my_edit();
var
   Res      : TModalResult;

begin
   if DM.QueryOsoby.RecordCount = 0 then begin
      EXIT;
   end;

   try
      DlgOsoba := TDlgOsoba.Create(Self);

      res := DlgOsoba.ShowModal();

      if res = mrOK then begin
         //
      end;
   finally
      FreeAndNil(DlgOsoba);
   end;
end;

end.
